using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.DAL;
using VIRP.EFR.UTIL;

namespace VIRP.EFR.BLL
{
    public static partial class STD_ANALYTETYPEManager
    {
        #region Fields
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static VIRP.EFR.BO.STD_ANALYTETYPE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            VIRP.EFR.BO.STD_ANALYTETYPE objReturn = null;
            STD_ANALYTETYPEDB objDB = new STD_ANALYTETYPEDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static List<VIRP.EFR.BO.STD_ANALYTETYPE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<VIRP.EFR.BO.STD_ANALYTETYPE> objReturn = null;
            STD_ANALYTETYPEDB objDB = new STD_ANALYTETYPEDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetActiveOrderedAnalyteTypes(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            var db = new STD_ANALYTETYPEDB();

            var analytes = db.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID)
                .Where(a => a.INACTIVE_FLAG == false && a.BIOMONITORING_FLAG == true)
                .OrderBy(a => a.NAME)
                .Select(a => new KeyValuePair<int, string>(a.ID, a.NAME))
                .ToList();

            var comparer = new KeyValueComparer();

            analytes.Sort(comparer);

            return analytes;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VIRP.EFR.BO.STD_ANALYTETYPE objSave)
        {
            Int32 objReturn = 0;
            STD_ANALYTETYPEDB objDB = new STD_ANALYTETYPEDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            Boolean objReturn = false;
            STD_ANALYTETYPEDB objDB = new STD_ANALYTETYPEDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VIRP.EFR.BO.STD_ANALYTETYPE objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.ID);
        }

        #endregion
    }
}
